#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <exec/exec.h>
#include <exec/execbase.h>
#include <exec/memory.h>
#include <proto/exec.h>
#include <proto/dos.h>

#include <iec/iec.h>

//----------------------------------------
//IECStatus 1.0
//
//Displays the status of drive 1541
//
//----------------------------------------


struct iecbase *IECBase;
struct RDArgs *rda;


LONG argv[1]={0};
char device=8;	//Default device #


char Version[]="$VER:IECStatus 1.0 (01.09.96) by Fabrizio Farenga";



void ReadStatus(void)
{
	//Ask for status
	//OPEN 15,8,15
	Listen(device);
	Second(CMD_OPEN+15);

	if (IECBase->iec_ST!=ST_OK)
		{
		printf ("\n?DEVICE NOT PRESENT\n\n");
		return;
		}

	UnListen();

	printf ("\n");

	//Receive data
	//GET#15
	Talk(device);
	TkSA(CMD_DATA+15);
		while (IECBase->iec_ST==ST_OK) printf ("%c",ACPtr());
	UnTalk();

	printf ("\n\n");

	//CLOSE
	Listen(device);
	Second(CMD_CLOSE+15);
	UnListen();
}


void main(void)
{

if ((rda = ReadArgs("Device/N",argv,NULL)) != NULL)
	{
	if (argv[0]!=0) device=*(LONG *)argv[0];	//Get device number
	FreeArgs(rda);
	}

if ((device<4)||(device>30))
	{
	printf ("\n?DEVICE NOT PRESENT\n\n");
	return;
	}

IECBase = (struct iecbase*)OpenLibrary("iec.library",0L);

if (IECBase!=0)
	{

	ReadStatus();

	CloseLibrary((struct Library*)IECBase);
	}
else
	{
	printf ("Can't open iec.library\n");
	return;
	}

}
